/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.DeviceType;
import com.cisco.pt.ipc.enums.ModuleType;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ipc.sim.TerminalLine;
import com.cisco.pt.ipc.sim.port.Port;
import com.cisco.pt.ipc.sim.process.Process;
import com.cisco.pt.ptmp.PacketTracerSession;

public class DeviceImpl
extends IPCObjectImpl
implements Device {
    public DeviceImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public void setName(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setName");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public String getName() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getName");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public void setPower(boolean bOn) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPower");
        newCall.addBoolParameter(bOn);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean getPower() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPower");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getPower");
        }
        return returnMessage.getBoolValue();
    }

    public double getXCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getXCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getXCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    public double getYCoordinate() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getYCoordinate");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getYCoordinate");
        }
        return returnMessage.getDoubleValue();
    }

    public boolean moveToLocation(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveToLocation");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveToLocation");
        }
        return returnMessage.getBoolValue();
    }

    public int getYPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getYPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getYPhysicalWS");
        }
        return returnMessage.getIntValue();
    }

    public int getXPhysicalWS() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getXPhysicalWS");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getXPhysicalWS");
        }
        return returnMessage.getIntValue();
    }

    public boolean moveToLocInPhysicalWS(int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveToLocInPhysicalWS");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.moveToLocInPhysicalWS");
        }
        return returnMessage.getBoolValue();
    }

    public DeviceType getType() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getType");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getType");
        }
        return DeviceType.fromIntValue(returnMessage.getIntValue());
    }

    public String getModel() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getModel");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public Port getPort(String portName) {
        return this.getFactory().getPort(this, portName);
    }

    public int getPortCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPortCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getPortCount");
        }
        return returnMessage.getIntValue();
    }

    public Port getPortAt(int index) {
        return this.getFactory().getPortAt(this, index);
    }

    public Process getProcess(String process) {
        return this.getFactory().getProcess(this, process);
    }

    public boolean addModule(String slot, ModuleType type, String model) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addModule");
        newCall.addStringParameter(slot);
        newCall.addIntParameter(type.getIntValue());
        newCall.addStringParameter(model);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.addModule");
        }
        return returnMessage.getBoolValue();
    }

    public boolean removeModule(String slot) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeModule");
        newCall.addStringParameter(slot);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.removeModule");
        }
        return returnMessage.getBoolValue();
    }

    public TerminalLine getCommandLine() {
        return this.getFactory().getCommandLine(this);
    }

    public void addCustomVar(String name, String var) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addCustomVar");
        newCall.addQStringParameter(name);
        newCall.addQStringParameter(var);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean removeCustomVar(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeCustomVar");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.removeCustomVar");
        }
        return returnMessage.getBoolValue();
    }

    public boolean hasCustomVar(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("hasCustomVar");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.hasCustomVar");
        }
        return returnMessage.getBoolValue();
    }

    public String getCustomVarStr(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarStr");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public int getCustomVarsCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarsCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DeviceImpl.getCustomVarsCount");
        }
        return returnMessage.getIntValue();
    }

    public String getCustomVarNameAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarNameAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public String getCustomVarValueStrAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCustomVarValueStrAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public String serializeToXml() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("serializeToXml");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public String activityTreeToXml() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("activityTreeToXml");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }
}

